//=============================================================================
// MPConvo_Trigger
//
// These didn't have to be triggers, but making them this way means you can
// also trigger these without convo (such as player touching a trigger, etc)
//
// If you want your own code called by MPConvo, just use function Trigger()
// in -any- actor. DoCoolStuff() is just for my own convenience.
//
// I also coded my own Trigger() to change mission conditions and call other
// triggers when finished. You don't have to do that either
//
//-----------------------------------------------------------------------------
// It's too late to implement, but I should have structured this with a
// function for checking the conditions too, not just DoBoringStuff();
// this would have made life easier for triggers that check things
//=============================================================================
Class MPConvo_Trigger extends Trigger;

enum convType
{
	Personal,
	Cooperative
};

var() convType missionType;
var() bool bCanTouch;
var() int missionNumber;
var() int checkMissionState;
var() int setMissionState;
var float coolDown;
var Pawn lastPawn;
var bool bCoop;

enum stateRange0 //enum seems unnecessary, but it's easier to understand in the editor
{
	Exactly,
	To_value2
//	Above, //this is more complicated to implement than simply using "from 1 to 99999"
//	Below  //same deal, inversely (same thing, even)
};

var() stateRange0 checkRange;
var() int checkValue2;

function Touch( actor Other )
{
	if(bCanTouch)
	{
		if(Other.IsA('DeusExPlayer'))
		{
			Trigger(Self, DeusExPlayer(Other));
		}
	}
}

function Trigger(Actor Other, Pawn EventInstigator) //Does Trigger() trigger Event? Just tested it, and nope. It doesn't.
{
	if((coolDown <= Level.TimeSeconds) || (EventInstigator != lastPawn))
	{	
		coolDown = Level.TimeSeconds + 0.5; //don't let spammy players cause lag
		lastPawn = EventInstigator;

		DoBoringStuff(DeusExPlayer(EventInstigator));
		DoCoolStuff(DeusExPlayer(EventInstigator));
	}
}

function DoCoolStuff(DeusExPlayer Instigator)
{
	//for child classes!!
}

function DoBoringStuff(DeusExPlayer Instigator)
{
	local MissionProgress A;
	local actor A2;

	foreach AllActors(class 'MissionProgress', A)
	{
		if(A.Owner == Instigator)
		{
			switch (checkRange)
			{
				case Exactly:

				if(checkMissionState == A.GetMissionState(missionNumber, bCoop))
				{
					A.SetMissionState(missionNumber,setMissionState, bCoop);
				}

				break;

				case To_value2:

				if((checkMissionState <= A.GetMissionState(missionNumber, bCoop)) && (checkMissionState >= A.GetMissionState(missionNumber, bCoop)))
				{
					A.SetMissionState(missionNumber,setMissionState, bCoop);
				}

				break;
			}
		}
	}

	if(Event != '')
	{
		foreach AllActors(class 'Actor', A2, Event)
		{
			A2.Trigger(Self,Instigator);
		}
	}
}

function BeginPlay()
{
	if(missionType == Cooperative)
	{
		bCoop = true;
	}

	Super.BeginPlay();
}

defaultproperties
{
     bCoop=false
     bCanTouch=false
     setMissionState=-999
}